<?php
    $color = \App\Models\CustomTemplate::find(1);
    $logoColor = $color && $color->logo_header_color ? $color->logo_header_color : 'blue';
    $topbarColor = $color && $color->topbar_color ? $color->topbar_color : 'blue2';
    $sidebarColor = $color && $color->sidebar_color ? $color->sidebar_color : 'white';
    $bgColor = $color && $color->bd_color ? $color->bd_color : 'bg1';

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
    <link rel="icon" href="<?php echo e(asset('icon/icon.png')); ?>" type="image/x-icon" />

    <?php echo $__env->make('partials.dashboard.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body data-background-color="<?php echo e($bgColor); ?>">
    <div class="wrapper">
        <div class="main-header">
            <!-- Logo Header -->
            <div class="logo-header" data-background-color="<?php echo e($logoColor); ?>">
                <a href="<?php echo e(route('dashboard')); ?>" class="logo">
                    <h1 class="text-white mt-3" style="font-weight: 800!important">ESDM</h1>
                    
                </a>
                <button class="navbar-toggler sidenav-toggler ml-auto" type="button" data-toggle="collapse"
                    data-target="collapse" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon">
                        <i class="icon-menu"></i>
                    </span>
                </button>
                <button class="topbar-toggler more"><i class="icon-options-vertical"></i></button>
                <div class="nav-toggle">
                    <button class="btn btn-toggle toggle-sidebar">
                        <i class="icon-menu"></i>
                    </button>
                </div>
            </div>
            <!-- End Logo Header -->

            
            <?php echo $__env->make('partials.dashboard.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            
        </div>

        <?php echo $__env->make('partials.dashboard.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="main-panel">
            <div class="container">
                <div class="page-inner mt-5">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
            <?php echo $__env->make('partials.dashboard.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <?php echo $__env->make('partials.dashboard.custom-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php echo $__env->make('partials.dashboard.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /Users/macbook/Downloads/ppid-kominfo-master 2/resources/views/layouts/dashboard.blade.php ENDPATH**/ ?>